/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.api.recipeHandlers;

import craftedMods.lotr.recipes.api.utils.LOTRRecipeHandlerUtils;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerCacheManager;
import craftedMods.recipes.api.RecipeHandlerConfiguration;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.utils.ItemStackSet;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.base.AbstractRecipeHandler;
import craftedMods.recipes.base.AbstractRecipeHandlerCacheManager;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.FurnaceRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lotr.client.gui.LOTRGuiAlloyForge;
import lotr.common.tileentity.LOTRTileEntityAlloyForgeBase;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Logger;

public abstract class AbstractAlloyForgeRecipeHandler
extends AbstractRecipeHandler<AlloyForgeRecipe> {
    protected final AlloyForgeAccess alloyForgeDummy;
    protected boolean wasCacheLoaded = false;
    protected boolean useHardcodedRecipes = false;
    private final AlloyForgeRecipeHandlerRenderer renderer = new AlloyForgeRecipeHandlerRenderer();
    private final AlloyForgeRecipeHandlerCacheManager cacheManager = new AlloyForgeRecipeHandlerCacheManager(this);
    private final AlloyForgeRecipeHandlerRecipeViewer recipeViewer = new AlloyForgeRecipeHandlerRecipeViewer(this);

    protected AbstractAlloyForgeRecipeHandler(String unlocalizedName, AlloyForgeAccess alloyForgeDummy) {
        super(unlocalizedName);
        this.alloyForgeDummy = alloyForgeDummy;
    }

    public void onPreLoad(RecipeHandlerConfiguration config, Logger logger) {
        super.onPreLoad(config, logger);
        this.useHardcodedRecipes = config.getBoolean("Use hardcoded recipes", false, "Enable this when you experience performance issues caused by this mod. This fixes that issue at the cost of lost compatibility - eventually NEI doesn't show all recipes this device supports.");
    }

    public void onPostLoad(Collection<AlloyForgeRecipe> staticRecipes) {
        super.onPostLoad(staticRecipes);
        if (this.useHardcodedRecipes) {
            Collection<AlloyForgeRecipe> hardcodedRecipes = this.getHardcodedRecipes();
            if (hardcodedRecipes.size() == 0) {
                this.logger.warn("This recipe handler was configured to load hardcoded recipes, but there weren't any - thus this handler shows no recipes.");
            } else {
                this.logger.debug("Found " + hardcodedRecipes.size() + " hardcoded recipes that will be used");
            }
            this.getStaticRecipes().addAll(this.getHardcodedRecipes());
        }
    }

    protected Collection<AlloyForgeRecipe> getHardcodedRecipes() {
        return Arrays.asList(new AlloyForgeRecipe[0]);
    }

    public String getDisplayName() {
        return this.alloyForgeDummy.getName();
    }

    public int getRecipesPerPage() {
        return 1;
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(AlloyForgeRecipe recipe, EnumRecipeItemRole role) {
        ArrayList<RecipeItemSlot> slots = new ArrayList<RecipeItemSlot>();
        switch (role) {
            case RESULT: {
                for (int i = 0; i < 4; ++i) {
                    slots.add(this.createRecipeItemSlot(48 + i * 18, 65));
                }
                break;
            }
            case INGREDIENT: {
                int size = recipe.getRecipeItems(EnumRecipeItemRole.INGREDIENT).size();
                for (int i = 0; i < size; ++i) {
                    slots.add(this.createRecipeItemSlot(48 + (size == 4 ? i : i / 2) * 18, size == 4 ? 19 : ((i + 1) % 2 == 0 ? 1 : 19)));
                }
                break;
            }
            case OTHER: {
                slots.add(this.createRecipeItemSlot(75, 109));
            }
        }
        return slots;
    }

    public int getComplicatedStaticRecipeDepth() {
        return this.useHardcodedRecipes || this.wasCacheLoaded ? 0 : 2;
    }

    public AlloyForgeRecipe loadComplicatedStaticRecipe(ItemStack ... stacks) {
        AlloyForgeRecipe ret = null;
        if (stacks[1] == null) {
            ItemStack result = this.alloyForgeDummy.getSmeltingResult(stacks[0]);
            if (result != null) {
                ret = new AlloyForgeRecipe(Arrays.asList(stacks[0]), result);
            }
        } else {
            ItemStack result = this.alloyForgeDummy.getAlloyResult(stacks[0], stacks[1]);
            if (result != null) {
                ret = new AlloyForgeRecipe(Arrays.asList(stacks), result);
            }
        }
        return ret;
    }

    public AlloyForgeRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public RecipeHandlerCacheManager<AlloyForgeRecipe> getCacheManager() {
        return this.cacheManager;
    }

    public RecipeHandlerRecipeViewer<AlloyForgeRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    public class AlloyForgeRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<AlloyForgeRecipe, AbstractAlloyForgeRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public AlloyForgeRecipeHandlerRecipeViewer(AbstractAlloyForgeRecipeHandler handler) {
            super((RecipeHandler)handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(LOTRGuiAlloyForge.class);
        }

        public Collection<AlloyForgeRecipe> getAllRecipes() {
            return ((AbstractAlloyForgeRecipeHandler)this.handler).getStaticRecipes();
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        public boolean isGuiContainerSupported(GuiContainer container) {
            LOTRTileEntityAlloyForgeBase forge;
            return !(container instanceof LOTRGuiAlloyForge) || (forge = LOTRRecipeHandlerUtils.getAlloyForge((LOTRGuiAlloyForge)container)).getForgeName().equals(((AbstractAlloyForgeRecipeHandler)this.handler).alloyForgeDummy.getName());
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return 9;
        }

        public int getOffsetY(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiAlloyForge.class ? 27 : 18;
        }
    }

    public static interface AlloyForgeAccess {
        public String getName();

        public ItemStack getSmeltingResult(ItemStack var1);

        public ItemStack getAlloyResult(ItemStack var1, ItemStack var2);
    }

    public static class AlloyForgeRecipe
    extends FurnaceRecipe {
        private final ItemStack ingredientItem;
        private final ItemStack alloyItem;
        private final ItemStack resultItem;

        public AlloyForgeRecipe(Collection<ItemStack> ingredients, ItemStack result) {
            super(ingredients, result);
            int i;
            for (i = 0; i < 3; ++i) {
                this.addAll(ingredients, this.ingredients);
            }
            for (i = 0; i < 3; ++i) {
                this.add(result, this.results);
            }
            this.ingredientItem = (ItemStack)((ItemStackSet)this.ingredients.get(0)).iterator().next();
            this.alloyItem = ingredients.size() == 2 ? (ItemStack)((ItemStackSet)this.ingredients.get(1)).iterator().next() : null;
            this.resultItem = result;
        }

        public static AlloyForgeRecipe readRecipeFromNBT(NBTTagCompound parent) {
            AlloyForgeRecipe ret = null;
            if (parent.func_74764_b("ingredientItem") && parent.func_74764_b("alloyItem") && parent.func_74764_b("resultItem")) {
                NBTTagCompound ingredientItem = parent.func_74775_l("ingredientItem");
                NBTTagCompound alloyItem = parent.func_74775_l("alloyItem");
                NBTTagCompound resultItem = parent.func_74775_l("resultItem");
                ItemStack alloyStack = alloyItem.func_74764_b("Identifier") ? RecipeHandlerUtils.getInstance().readItemStackFromNBT(alloyItem) : null;
                ArrayList<ItemStack> ingreds = new ArrayList<ItemStack>();
                ingreds.add(RecipeHandlerUtils.getInstance().readItemStackFromNBT(ingredientItem));
                if (alloyStack != null) {
                    ingreds.add(alloyStack);
                }
                ret = new AlloyForgeRecipe(ingreds, RecipeHandlerUtils.getInstance().readItemStackFromNBT(resultItem));
            }
            return ret;
        }

        public void writeRecipeToNBT(NBTTagCompound parent) {
            NBTTagCompound ingredientItem = new NBTTagCompound();
            NBTTagCompound alloyItem = new NBTTagCompound();
            NBTTagCompound resultItem = new NBTTagCompound();
            RecipeHandlerUtils.getInstance().writeItemStackToNBT(this.ingredientItem, ingredientItem);
            if (this.alloyItem != null) {
                RecipeHandlerUtils.getInstance().writeItemStackToNBT(this.alloyItem, alloyItem);
            }
            RecipeHandlerUtils.getInstance().writeItemStackToNBT(this.resultItem, resultItem);
            parent.func_74782_a("ingredientItem", (NBTBase)ingredientItem);
            parent.func_74782_a("alloyItem", (NBTBase)alloyItem);
            parent.func_74782_a("resultItem", (NBTBase)resultItem);
        }
    }

    public class AlloyForgeRecipeHandlerRenderer
    implements RecipeHandlerRenderer<AbstractAlloyForgeRecipeHandler, AlloyForgeRecipe> {
        public void renderBackground(AbstractAlloyForgeRecipeHandler handler, AlloyForgeRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("lotr:gui/forge.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(15, 0, 20, 20, 110, 130);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(75, 37, 176, 14, 16, 30, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.INCREASE_DOWN);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(76, 93, 176, 0, 14, 13, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.DECREASE_DOWN);
        }

        public void renderForeground(AbstractAlloyForgeRecipeHandler handler, AlloyForgeRecipe recipe, int cycleticks) {
        }
    }

    public class AlloyForgeRecipeHandlerCacheManager
    extends AbstractRecipeHandlerCacheManager<AlloyForgeRecipe> {
        public AlloyForgeRecipeHandlerCacheManager(AbstractAlloyForgeRecipeHandler handler) {
            super((RecipeHandler)handler);
        }

        public boolean isCacheEnabled() {
            return !((AbstractAlloyForgeRecipeHandler)this.handler).useHardcodedRecipes;
        }

        public Collection<AlloyForgeRecipe> readRecipesFromCache(NBTTagCompound cacheHeaderTag, NBTTagCompound cacheContentTag) {
            ArrayList<AlloyForgeRecipe> ret = new ArrayList<AlloyForgeRecipe>(150);
            for (String key : cacheContentTag.func_150296_c()) {
                NBTTagCompound recipeTag = cacheContentTag.func_74775_l(key);
                AlloyForgeRecipe recipe = AlloyForgeRecipe.readRecipeFromNBT(recipeTag);
                if (recipe == null) continue;
                ret.add(recipe);
            }
            AbstractAlloyForgeRecipeHandler.this.wasCacheLoaded = ret.size() > 0;
            return ret;
        }

        public void writeRecipesToCache(NBTTagCompound cacheHeaderTag, NBTTagCompound cacheContentTag) {
            super.writeRecipesToCache(cacheHeaderTag, cacheContentTag);
            int recipeIndex = 0;
            for (AlloyForgeRecipe recipe : AbstractAlloyForgeRecipeHandler.this.staticRecipes) {
                NBTTagCompound recipeTag = new NBTTagCompound();
                recipe.writeRecipeToNBT(recipeTag);
                cacheContentTag.func_74782_a(Integer.toString(recipeIndex++), (NBTBase)recipeTag);
            }
        }
    }
}

